
-- Creates the given camera class (FreeCamera, TargetCamera, PhysicalCamera) from the current view
-- Used by the macroscript associated with ctrl-c
fn CreateCameraFromView camera_class =
(
	--camera variable
	local c
	local wcol = (color 5 54 179)
	local targdist = viewport.GetFocalDistance()
	-- get viewport tm
	local viewfov = getVIewFOV()
	local cXform =  InverseHighPrecision(viewport.getTM())
	  
	--disablesceneredraw() 
	-- perspective views
	if viewport.Gettype() == #view_persp_user
	then
	(
	if (superclassof selection[1]) == camera --check if selection is a camera
		then --if selection is a camera, than call the match camera to view action
		(
			actionMan.executeAction 0 "40249" --loc_notes: do not localize this
		)
		else --if selection is not a camera, then create it for the user
		(
			-- creates a camera, and assigns the current Vport Transforms
			c = camera_class  targetDistance:targdist isSelected:on wirecolor:wcol
			-- Physical camera needs to be set to "Specify FOV"
			if(camera_class == Physical_Camera) then
			(
				c.specify_fov = true
			)
			c.fov = viewfov			
			-- Force perspective camera. Standard camera has "orthoProjection" property, but Physical camera doesn't.
			if(hasproperty c "orthoProjection") then
			(
				c.orthoProjection = false 
			)
			c.Transform = cXform 
			viewport.setcamera c
			if(Perspective_Match.IsMatching() == false) then
			(
				-- Standard camera has "type", Physical camera has "targeted"
				if(hasproperty c "type") then
					c.type = #target
				else if(hasproperty c "targeted") then
					c.targeted = true
				c.target.wirecolor = wcol
			)
			else
			(
				-- Standard camera has "type", Physical camera has "targeted"
				if(hasproperty c "type") then
					c.type = #free
				else if(hasproperty c "targeted") then
					c.targeted = false				
			)
		)--end then
	)--end then
	else
	(

	)--end else

	-- clears the local variables
	c = undefined 
	viewfov = undefined
	cXform  = undefined
	  
	--enablesceneredraw()
) 